CREATE TABLE IF NOT EXISTS `context_on_site_rtb` (
    `campaign_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `geo` MEDIUMTEXT,
    `mincpm` DECIMAL(10, 3) UNSIGNED,
    `comment` TEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `media_active` BOOLEAN,
    `media_blocked` BOOLEAN,
    `media_cpm` DECIMAL(10, 3) UNSIGNED,
    `text_active` BOOLEAN,
    `text_blocked` BOOLEAN,
    `text_cpm` DECIMAL(10, 3) UNSIGNED,
    `opts` JSON NOT NULL,
    `horizontal_align` BOOLEAN DEFAULT '1',
    `alternative_code` TEXT NOT NULL DEFAULT '',
    `blind` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '1',
    `alt_width` SMALLINT UNSIGNED,
    `alt_height` SMALLINT UNSIGNED,
    `active` BOOLEAN DEFAULT '1',
    `ex_direct` BOOLEAN DEFAULT '0',
    `duplicate_direct` BOOLEAN DEFAULT '0',
    `show_video` BOOLEAN NOT NULL DEFAULT '0',
    `from_trigger` BOOLEAN NOT NULL DEFAULT '0',
    `site_version` ENUM('desktop', 'mobile', 'turbo', 'amp', 'turbo_desktop', 'mobile_fullscreen', 'mobile_rewarded', 'mobile_floorad', 'general') NOT NULL DEFAULT 'desktop',
    `model` ENUM('context_on_site_rtb', 'internal_context_on_site_rtb', 'mobile_app_rtb', 'context_on_site_content', 'internal_mobile_app_rtb') NOT NULL DEFAULT 'context_on_site_rtb',
    `adfox_block` BOOLEAN NOT NULL DEFAULT '0',
    `video_active` BOOLEAN DEFAULT NULL,
    `video_blocked` BOOLEAN DEFAULT NULL,
    `video_cpm` DECIMAL(10, 3) UNSIGNED DEFAULT NULL,
    `unique_id` BIGINT UNSIGNED NOT NULL,
    `block_type` VARCHAR(18),
    `direct_block` VARCHAR(32),
    `media_block` VARCHAR(12),
    `place_id` INT UNSIGNED,
    PRIMARY KEY (`campaign_id`, `id`),
    INDEX `context_on_site_rtb__id` (`id`),
    UNIQUE INDEX `uniq_context_on_site_rtb__unique_id` (`unique_id`),
    INDEX `context_on_site_rtb__model` (`model`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'