CREATE TABLE IF NOT EXISTS `contracts` (
    `id` BIGINT UNSIGNED NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `type` VARCHAR(32) NOT NULL,
    `external_id` VARCHAR(32) NOT NULL,
    `client_id` BIGINT UNSIGNED NOT NULL,
    `dt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `end_dt` DATETIME,
    `update_dt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `contract` VARCHAR(1024) NOT NULL,
    `opts` JSON NOT NULL,
    `person_id` BIGINT GENERATED ALWAYS AS (`contract`->"$.person_id") VIRTUAL,
    PRIMARY KEY (`id`),
    INDEX `contracts__multistate` (`multistate`),
    INDEX `contracts__client_id` (`client_id`),
    INDEX `contracts__dt_end_dt` (`dt`, `end_dt`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'