CREATE TABLE IF NOT EXISTS `crons_raw_stat` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `cron_id` INT UNSIGNED NOT NULL,
    `dt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `duration` INT UNSIGNED NOT NULL,
    `ignored` BOOLEAN NOT NULL,
    `ok` BOOLEAN NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `crons_raw_stat__cron_id_ignored_ok` (`cron_id`, `ignored`, `ok`),
    INDEX `crons_raw_stat__dt` (`dt`),
    FOREIGN KEY `fk_crons_raw_stat__cron_id___crons__id` (`cron_id`)
        REFERENCES `crons` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'