CREATE TABLE IF NOT EXISTS `distribution_campaign` (
    `id` INT UNSIGNED NOT NULL,
    `page_id` INT UNSIGNED,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `comment` TEXT,
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    `blocks_limit` INT NOT NULL DEFAULT '400',
    `blocks_count` INT NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_distribution_campaign__page_id` (`page_id`),
    FOREIGN KEY `fk_distribution_campaign__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_distribution_campaign__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'