CREATE TABLE IF NOT EXISTS `event_log` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `date` DATE NOT NULL,
    `create_dt` DATETIME NOT NULL,
    `create_user_id` BIGINT UNSIGNED NOT NULL,
    `description` VARCHAR(512) NOT NULL DEFAULT '',
    `level` VARCHAR(512) NOT NULL,
    `element` VARCHAR(512),
    `type_id` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `class_id` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `pi_id` INT UNSIGNED,
    PRIMARY KEY (`id`),
    INDEX `event_log__date` (`date`),
    FOREIGN KEY `fk_event_log__create_user_id___users__id` (`create_user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'