CREATE TABLE IF NOT EXISTS `indoor` (
    `id` INT UNSIGNED NOT NULL,
    `page_id` INT UNSIGNED,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.caption") VIRTUAL NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `blocks_limit` BIGINT NOT NULL DEFAULT '200',
    `blocks_count` BIGINT NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `tier` TINYINT DEFAULT '3',
    `comment` TEXT,
    `address` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.address") STORED NOT NULL,
    `waiting_moderation` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `gps` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.gps") VIRTUAL NOT NULL,
    `facility_type` TINYINT GENERATED ALWAYS AS (opts->>"$.facility_type") VIRTUAL NOT NULL,
    `business_oid` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.business_oid") VIRTUAL,
    `patch` JSON,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_indoor__page_id` (`page_id`),
    FOREIGN KEY `fk_indoor__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_indoor__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'