CREATE TABLE IF NOT EXISTS `indoor_block` (
    `page_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) GENERATED ALWAYS AS (opts->"$.caption") VIRTUAL NOT NULL,
    `resolution` VARCHAR(11) GENERATED ALWAYS AS (opts->"$.resolution") VIRTUAL NOT NULL,
    `touch_screen` BOOLEAN GENERATED ALWAYS AS (opts->"$.touch_screen") VIRTUAL NOT NULL,
    `sound` BOOLEAN GENERATED ALWAYS AS (opts->"$.sound") VIRTUAL NOT NULL,
    `zone_category` TINYINT GENERATED ALWAYS AS (opts->"$.zone_category") VIRTUAL NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `comment` TEXT,
    `waiting_moderation` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    PRIMARY KEY (`page_id`, `id`),
    INDEX `indoor_block__multistate` (`multistate`),
    INDEX `indoor_block__id` (`id`),
    FOREIGN KEY `fk_indoor_block__page_id___indoor__page_id` (`page_id`)
        REFERENCES `indoor` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'