CREATE TABLE IF NOT EXISTS `internal_context_on_site_campaign` (
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `site_id` INT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `family_filter` BOOLEAN NOT NULL DEFAULT '0',
    `from_trigger` BOOLEAN NOT NULL DEFAULT '0',
    `behavioral_targeting` BOOLEAN NOT NULL DEFAULT '1',
    `view_images` BOOLEAN NOT NULL DEFAULT '1',
    `reload_timeout` TINYINT UNSIGNED NOT NULL DEFAULT '30',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `comment` TEXT,
    `block_title` VARCHAR(255) DEFAULT '',
    `fast_context` BOOLEAN NOT NULL DEFAULT '1',
    `only_picture` BOOLEAN NOT NULL DEFAULT '0',
    `mobile_app_mode` TINYINT NOT NULL DEFAULT '0',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `page_lang` INT UNSIGNED NOT NULL DEFAULT '1',
    `allowed_turbo` BOOLEAN NOT NULL DEFAULT '1',
    `metrica_counters` VARCHAR(1024) NOT NULL DEFAULT '',
    `unmoderated_rtb_auction` BOOLEAN NOT NULL DEFAULT '0',
    `performance_tgo_disable` BOOLEAN NOT NULL DEFAULT '0',
    `blocks_limit` INT NOT NULL DEFAULT '400',
    `blocks_count` INT NOT NULL DEFAULT '0',
    `tier` TINYINT DEFAULT '3',
    `opts` JSON NOT NULL,
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    PRIMARY KEY (`id`),
    FOREIGN KEY `fk_internal_context_on_site_campaign__site_id___internal_site__` (`site_id`)
        REFERENCES `internal_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_internal_context_on_site_campaign__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'