CREATE TABLE IF NOT EXISTS `internal_mobile_app` (
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `type` TINYINT UNSIGNED NOT NULL,
    `store_id` VARCHAR(255),
    `store_url` VARCHAR(255),
    `caption` VARCHAR(255) NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `family_filter` BOOLEAN NOT NULL DEFAULT '0',
    `behavioral_targeting` BOOLEAN NOT NULL DEFAULT '1',
    `view_images` BOOLEAN NOT NULL DEFAULT '1',
    `comment` TEXT,
    `block_title` VARCHAR(255) DEFAULT '',
    `fast_context` BOOLEAN NOT NULL DEFAULT '1',
    `only_picture` BOOLEAN NOT NULL DEFAULT '0',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `false_click` BOOLEAN NOT NULL DEFAULT '0',
    `from_trigger` BOOLEAN NOT NULL DEFAULT '0',
    `unmoderated_rtb_auction` BOOLEAN NOT NULL DEFAULT '0',
    `performance_tgo_disable` BOOLEAN NOT NULL DEFAULT '0',
    `tier` TINYINT DEFAULT '3',
    `opts` JSON NOT NULL,
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    `blocks_limit` INT NOT NULL DEFAULT '400',
    `blocks_count` INT NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    INDEX `internal_mobile_app__multistate` (`multistate`),
    FOREIGN KEY `fk_internal_mobile_app__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'