CREATE TABLE IF NOT EXISTS `internal_search_on_site_campaign` (
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `site_id` INT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `family_filter` BOOLEAN NOT NULL,
    `reload_timeout` TINYINT UNSIGNED NOT NULL DEFAULT '30',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `comment` TEXT,
    `block_title` VARCHAR(255) DEFAULT '',
    `mobile_app_mode` TINYINT NOT NULL DEFAULT '0',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `page_lang` INT UNSIGNED NOT NULL DEFAULT '1',
    `metrica_counters` VARCHAR(1024) NOT NULL DEFAULT '',
    `tier` TINYINT DEFAULT '3',
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `patch` JSON,
    `blocks_limit` INT NOT NULL DEFAULT '400',
    `blocks_count` INT NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    FOREIGN KEY `fk_internal_search_on_site_campaign__site_id___internal_site__i` (`site_id`)
        REFERENCES `internal_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_internal_search_on_site_campaign__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'