CREATE TABLE IF NOT EXISTS `internal_search_on_site_direct_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_campaign_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `internal_search_on_site_direct_action_log__dt_elem_campaign_id_e` (`dt`, `elem_campaign_id`, `elem_id`, `action`),
    INDEX `internal_search_on_site_direct_action_log__elem_campaign_id_elem` (`elem_campaign_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_internal_search_on_site_direct_action_log__user_id___users__` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_internal_search_on_site_direct_action_log__elem_campaign_id_` (`elem_campaign_id`, `elem_id`)
        REFERENCES `internal_search_on_site_direct` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'