CREATE TABLE IF NOT EXISTS `mds_avatars` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `group_id` INT UNSIGNED NOT NULL,
    `imagename` VARCHAR(256) NOT NULL,
    `md5` CHAR(32) NOT NULL,
    `update_dt` DATETIME NOT NULL,
    `links` JSON NOT NULL,
    `block_cnt` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_mds_avatars__user_id_md5` (`user_id`, `md5`),
    INDEX `mds_avatars__update_dt_block_cnt` (`update_dt`, `block_cnt`),
    FOREIGN KEY `fk_mds_avatars__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'