CREATE TABLE IF NOT EXISTS `migrations` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `source_type` ENUM('perl', 'java') NOT NULL DEFAULT 'perl',
    `order_type` ENUM('before', 'after') NOT NULL,
    `db_type` ENUM('mysql', 'clickhouse') NOT NULL DEFAULT 'mysql',
    `name` VARCHAR(256) NOT NULL,
    `time_start` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `time_stop` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `result_code` BIGINT,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_migrations__name_order_type` (`name`, `order_type`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'