CREATE TABLE IF NOT EXISTS `mobile_app` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `type` TINYINT UNSIGNED,
    `store_id` VARCHAR(255),
    `store_url` VARCHAR(255),
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `comment` TEXT,
    `waiting_moderation` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `done_moderation` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `opts` JSON NOT NULL,
    `is_mobile_mediation` BOOLEAN GENERATED ALWAYS AS (opts->"$.is_mobile_mediation") STORED NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `mobile_app__type_store_id` (`type`, `store_id`),
    INDEX `mobile_app__multistate` (`multistate`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'