CREATE TABLE IF NOT EXISTS `mobile_app_owner` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `app_id` INT UNSIGNED NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_mobile_app_owner__app_id_user_id` (`app_id`, `user_id`),
    FOREIGN KEY `fk_mobile_app_owner__app_id___mobile_app__id` (`app_id`)
        REFERENCES `mobile_app` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_mobile_app_owner__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'