CREATE TABLE IF NOT EXISTS `mobile_app_settings` (
    `id` INT UNSIGNED NOT NULL,
    `application_id` INT UNSIGNED NOT NULL,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `context_page_id` INT UNSIGNED,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `caption` VARCHAR(255) NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `family_filter` BOOLEAN NOT NULL DEFAULT '0',
    `from_trigger` BOOLEAN NOT NULL DEFAULT '0',
    `behavioral_targeting` BOOLEAN NOT NULL DEFAULT '1',
    `view_images` BOOLEAN NOT NULL DEFAULT '1',
    `comment` TEXT,
    `block_title` VARCHAR(255) DEFAULT '',
    `fast_context` BOOLEAN NOT NULL DEFAULT '1',
    `only_picture` BOOLEAN NOT NULL DEFAULT '0',
    `cpa` INT UNSIGNED,
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `false_click` BOOLEAN NOT NULL DEFAULT '0',
    `unmoderated_rtb_auction` BOOLEAN NOT NULL DEFAULT '0',
    `performance_tgo_disable` BOOLEAN NOT NULL DEFAULT '0',
    `blocks_limit` BIGINT NOT NULL DEFAULT '200',
    `blocks_count` BIGINT NOT NULL DEFAULT '0',
    `tier` TINYINT DEFAULT '3',
    `opts` JSON NOT NULL,
    `is_mobile_mediation` BOOLEAN GENERATED ALWAYS AS (opts->"$.is_mobile_mediation") STORED,
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    PRIMARY KEY (`id`),
    INDEX `mobile_app_settings__multistate` (`multistate`),
    UNIQUE INDEX `uniq_mobile_app_settings__context_page_id` (`context_page_id`),
    FOREIGN KEY `fk_mobile_app_settings__application_id___mobile_app__id` (`application_id`)
        REFERENCES `mobile_app` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_mobile_app_settings__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_mobile_app_settings__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'