CREATE TABLE IF NOT EXISTS `moderation_reason` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `group_id` INT UNSIGNED NOT NULL DEFAULT '999999',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `manager_txt_en` VARCHAR(512), `manager_txt_ru` VARCHAR(512),
    `partner_txt_en` VARCHAR(512), `partner_txt_ru` VARCHAR(512),
    `timeout` BIGINT NOT NULL DEFAULT '-1',
    `owner_id` BIGINT UNSIGNED NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_moderation_reason__id_group_id` (`id`, `group_id`),
    FOREIGN KEY `fk_moderation_reason__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'