CREATE TABLE IF NOT EXISTS `news` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `change_date` TIMESTAMP NOT NULL,
    `date` DATE NOT NULL,
    `title` VARCHAR(1000) NOT NULL,
    `text` MEDIUMTEXT,
    `show_on_main_page` BOOLEAN NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `news__change_date` (`change_date`),
    INDEX `news__date` (`date`),
    FOREIGN KEY `fk_news__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'