CREATE TABLE IF NOT EXISTS `notification` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `type` ENUM('custom', 'auto') NOT NULL DEFAULT 'custom',
    `short_name` VARCHAR(16) NOT NULL,
    `view_type` ENUM('default', 'common_offer', 'custom_link', 'survey', 'top') NOT NULL DEFAULT 'default',
    `ttl` INT UNSIGNED NOT NULL,
    `caption_en` VARCHAR(255) NOT NULL, `caption_ru` VARCHAR(255) NOT NULL,
    `icon_id` VARCHAR(255) NOT NULL,
    `message_en` VARCHAR(1000) NOT NULL, `message_ru` VARCHAR(1000) NOT NULL,
    `button_caption_en` VARCHAR(255), `button_caption_ru` VARCHAR(255),
    `url` VARCHAR(255),
    `expectation_caption_en` VARCHAR(255), `expectation_caption_ru` VARCHAR(255),
    `expected_growth` INT UNSIGNED DEFAULT '0',
    `opts` JSON NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_notification__short_name` (`short_name`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'