CREATE TABLE IF NOT EXISTS `outdoor_block` (
    `page_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) GENERATED ALWAYS AS (opts->"$.caption") VIRTUAL NOT NULL,
    `resolution` VARCHAR(11) GENERATED ALWAYS AS (opts->"$.resolution") VIRTUAL NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `comment` TEXT,
    `waiting_moderation` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    PRIMARY KEY (`page_id`, `id`),
    INDEX `outdoor_block__multistate` (`multistate`),
    INDEX `outdoor_block__id` (`id`),
    FOREIGN KEY `fk_outdoor_block__page_id___outdoor__page_id` (`page_id`)
        REFERENCES `outdoor` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'