CREATE TABLE IF NOT EXISTS `pages` (
    `allowed_amp` BOOLEAN NOT NULL DEFAULT '1',
    `allowed_turbo` BOOLEAN NOT NULL DEFAULT '1',
    `blocks_limit` BIGINT NOT NULL DEFAULT '200',
    `blocks_count` BIGINT NOT NULL DEFAULT '0',
    `caption` VARCHAR(255) DEFAULT '',
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `domain_id` BIGINT,
    `from_trigger` BOOLEAN NOT NULL DEFAULT '0',
    `id` INT UNSIGNED NOT NULL,
    `model` ENUM('context_on_site_campaign', 'internal_context_on_site_campaign', 'internal_mobile_app', 'mobile_app_settings') NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `opts` JSON NOT NULL,
    `owner_id` BIGINT UNSIGNED,
    `page_id` BIGINT UNSIGNED NOT NULL,
    `unmoderated_rtb_auction` BOOLEAN NOT NULL DEFAULT '0',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `creator_id` BIGINT NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_pages__page_id` (`page_id`),
    FOREIGN KEY `fk_pages__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'