-- INSERT TRIGGERS --
DROP TRIGGER IF EXISTS `external_campaign_insert`;
DELIMITER $$
CREATE TRIGGER external_campaign_insert
    BEFORE INSERT
    ON context_on_site_campaign
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (allowed_amp,
                           allowed_turbo,
                           blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           owner_id,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.allowed_amp,
                NEW.allowed_turbo,
                NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.domain_id,
                1,
                NEW.id,
                'context_on_site_campaign',
                NEW.multistate,
                NEW.opts,
                NEW.owner_id,
                NEW.page_id,
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_campaign_insert`;
DELIMITER $$
CREATE TRIGGER internal_campaign_insert
    BEFORE INSERT
    ON internal_context_on_site_campaign
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (allowed_turbo,
                           blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.allowed_turbo,
                NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.site_id,
                1,
                NEW.id,
                'internal_context_on_site_campaign',
                NEW.multistate,
                NEW.opts,
                NEW.id, -- is page_id for internal
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `mobile_app_settings_insert`;
DELIMITER $$
CREATE TRIGGER mobile_app_settings_insert
    BEFORE INSERT
    ON mobile_app_settings
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           owner_id,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.application_id,
                1,
                NEW.id,
                'mobile_app_settings',
                NEW.multistate,
                NEW.opts,
                NEW.owner_id,
                NEW.context_page_id,
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_mobile_app_insert`;
DELIMITER $$
CREATE TRIGGER internal_mobile_app_insert
    BEFORE INSERT
    ON internal_mobile_app
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.id, -- internal_mobile_app is a domain for itself
                1,
                NEW.id,
                'internal_mobile_app',
                NEW.multistate,
                NEW.opts,
                NEW.id, -- is page_id for internal
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

-- UPDATE TRIGGERS ---
DROP TRIGGER IF EXISTS `external_campaign_update`;
DELIMITER $$
CREATE TRIGGER external_campaign_update
    BEFORE UPDATE
    ON context_on_site_campaign
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        UPDATE pages
        set allowed_amp             = NEW.allowed_amp,
            allowed_turbo           = NEW.allowed_turbo,
            blocks_count            = NEW.blocks_count,
            blocks_limit            = NEW.blocks_limit,
            caption                 = NEW.caption,
            create_date             = NEW.create_date,
            domain_id               = NEW.domain_id,
            from_trigger            = 1,
            id                      = NEW.id,
            multistate              = NEW.multistate,
            opts                    = NEW.opts,
            owner_id                = NEW.owner_id,
            page_id                 = NEW.page_id,
            unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
            update_time             = NEW.update_time,
            creator_id              = NEW.creator_id
        where model = 'context_on_site_campaign'
          AND id = OLD.id;
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_campaign_update`;
DELIMITER $$
CREATE TRIGGER internal_campaign_update
    BEFORE UPDATE
    ON internal_context_on_site_campaign
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        UPDATE pages
        set allowed_turbo           = NEW.allowed_turbo,
            blocks_count            = NEW.blocks_count,
            blocks_limit            = NEW.blocks_limit,
            caption                 = NEW.caption,
            create_date             = NEW.create_date,
            domain_id               = NEW.site_id,
            from_trigger            = 1,
            id                      = NEW.id,
            multistate              = NEW.multistate,
            opts                    = NEW.opts,
            page_id                 = NEW.id,
            unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
            update_time             = NEW.update_time,
            creator_id              = NEW.creator_id
        where model = 'internal_context_on_site_campaign'
          AND id = OLD.id;
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `mobile_app_settings_update`;
DELIMITER $$
CREATE TRIGGER mobile_app_settings_update
    BEFORE UPDATE
    ON mobile_app_settings
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        UPDATE pages
        set blocks_count            = NEW.blocks_count,
            blocks_limit            = NEW.blocks_limit,
            caption                 = NEW.caption,
            create_date             = NEW.create_date,
            domain_id               = NEW.application_id,
            from_trigger            = 1,
            id                      = NEW.id,
            multistate              = NEW.multistate,
            opts                    = NEW.opts,
            owner_id                = NEW.owner_id,
            page_id                 = NEW.context_page_id,
            unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
            update_time             = NEW.update_time,
            creator_id              = NEW.creator_id
        where model = 'mobile_app_settings'
          AND id = OLD.id;
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_mobile_app_update`;
DELIMITER $$
CREATE TRIGGER internal_mobile_app_update
    BEFORE UPDATE
    ON internal_mobile_app
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
    UPDATE pages
    set blocks_count            = NEW.blocks_count,
        blocks_limit            = NEW.blocks_limit,
        caption                 = NEW.caption,
        create_date             = NEW.create_date,
        domain_id               = NEW.id,
        from_trigger            = 1,
        id                      = NEW.id,
        multistate              = NEW.multistate,
        opts                    = NEW.opts,
        page_id                 = NEW.id,
        unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
        update_time             = NEW.update_time,
        creator_id              = NEW.creator_id
    where model = 'internal_mobile_app'
      AND id = OLD.id;
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `pages_update`;
DELIMITER $$
CREATE TRIGGER pages_update
    BEFORE UPDATE
    ON pages
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        IF (OLD.model = 'context_on_site_campaign')
        THEN
            UPDATE context_on_site_campaign
            set allowed_turbo           = NEW.allowed_turbo,
                blocks_count            = NEW.blocks_count,
                blocks_limit            = NEW.blocks_limit,
                caption                 = NEW.caption,
                create_date             = NEW.create_date,
                from_trigger            = 1,
                id                      = NEW.id,
                multistate              = NEW.multistate,
                opts                    = NEW.opts,
                page_id                 = NEW.id,
                unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
                update_time             = NEW.update_time,
                creator_id              = NEW.creator_id
            where id = OLD.id;
        ELSEIF (OLD.model = 'internal_context_on_site_campaign')
        THEN
            UPDATE internal_context_on_site_campaign
            set allowed_turbo           = NEW.allowed_turbo,
                blocks_count            = NEW.blocks_count,
                blocks_limit            = NEW.blocks_limit,
                caption                 = NEW.caption,
                create_date             = NEW.create_date,
                site_id                 = NEW.domain_id,
                from_trigger            = 1,
                id                      = NEW.id,
                multistate              = NEW.multistate,
                opts                    = NEW.opts,
                unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
                update_time             = NEW.update_time,
                creator_id              = NEW.creator_id
            where id = OLD.id;
        ELSEIF (OLD.model = 'mobile_app_settings')
        THEN
            UPDATE mobile_app_settings
            set blocks_count            = NEW.blocks_count,
                blocks_limit            = NEW.blocks_limit,
                caption                 = NEW.caption,
                create_date             = NEW.create_date,
                application_id          = NEW.domain_id,
                from_trigger            = 1,
                id                      = NEW.id,
                multistate              = NEW.multistate,
                opts                    = NEW.opts,
                owner_id                = NEW.owner_id,
                context_page_id         = NEW.page_id,
                unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
                update_time             = NEW.update_time,
                creator_id              = NEW.creator_id
            where id = OLD.id;
        ELSEIF (OLD.model = 'internal_mobile_app')
            THEN
        UPDATE internal_mobile_app
        set blocks_count            = NEW.blocks_count,
            blocks_limit            = NEW.blocks_limit,
            caption                 = NEW.caption,
            create_date             = NEW.create_date,
            from_trigger            = 1,
            id                      = NEW.id,
            multistate              = NEW.multistate,
            opts                    = NEW.opts,
            unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
            update_time             = NEW.update_time,
            creator_id              = NEW.creator_id
        where id = OLD.id;
        END IF;
    ELSE
        SET NEW.from_trigger = 0;
    END IF;
END;
$$
DELIMITER ;

