CREATE TABLE IF NOT EXISTS `search_on_site_direct` (
    `campaign_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `type` VARCHAR(10) NOT NULL,
    `limit` INT UNSIGNED,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `border_radius` BOOLEAN DEFAULT '0',
    `favicon` BOOLEAN NOT NULL DEFAULT '0',
    `no_sitelinks` BOOLEAN NOT NULL DEFAULT '0',
    `links_underline` BOOLEAN NOT NULL DEFAULT '1',
    `border_type` VARCHAR(8) NOT NULL,
    `site_bg_color` VARCHAR(6) NOT NULL,
    `bg_color` VARCHAR(6),
    `border_color` VARCHAR(6),
    `header_bg_color` VARCHAR(6),
    `sitelinks_color` VARCHAR(6),
    `title_color` VARCHAR(6) NOT NULL,
    `text_color` VARCHAR(6) NOT NULL,
    `url_color` VARCHAR(6) NOT NULL,
    `url_background_color` VARCHAR(6),
    `hover_color` VARCHAR(6) NOT NULL,
    `font_family` VARCHAR(15),
    `font_size` VARCHAR(3),
    `title_font_size` TINYINT UNSIGNED,
    `comment` TEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `pi_id` INT UNSIGNED,
    PRIMARY KEY (`campaign_id`, `id`),
    FOREIGN KEY `fk_search_on_site_direct__campaign_id___search_on_site_campaign` (`campaign_id`)
        REFERENCES `search_on_site_campaign` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'