CREATE TABLE IF NOT EXISTS `ssp_impression_log` (
    `date` DATE NOT NULL,
    `source_type` VARCHAR(16) NOT NULL,
    `hits` INT UNSIGNED NOT NULL,
    `seller_id` INT UNSIGNED NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `source_token_id` VARCHAR(128) NOT NULL,
    `source_token` VARCHAR(1024) COLLATE 'utf8_bin' NOT NULL,
    `source_domain` VARCHAR(255) NOT NULL,
    `source_domain_formats` VARCHAR(255) NOT NULL,
    `source_app` VARCHAR(255) COLLATE 'utf8_bin' NOT NULL,
    `source_app_os` VARCHAR(128) NOT NULL,
    `application_id` BIGINT UNSIGNED,
    `site_id` BIGINT UNSIGNED,
    PRIMARY KEY (`date`, `seller_id`, `source_token_id`, `source_type`, `page_id`),
    INDEX `ssp_impression_log__date` (`date`),
    INDEX `ssp_impression_log__application_id` (`application_id`),
    INDEX `ssp_impression_log__source_token` (`source_token`),
    FOREIGN KEY `fk_ssp_impression_log__seller_id___ssp_seller__id` (`seller_id`)
        REFERENCES `ssp_seller` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_impression_log__site_id___ssp_site__id` (`site_id`)
        REFERENCES `ssp_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_impression_log__application_id___ssp_application__id` (`application_id`)
        REFERENCES `ssp_application` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'