CREATE TABLE IF NOT EXISTS `ssp_link_context_rtb` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `site_id` BIGINT UNSIGNED DEFAULT NULL,
    `context_rtb_id` INT UNSIGNED DEFAULT NULL,
    `tokens` VARCHAR(10000) NOT NULL,
    `weight` BIGINT UNSIGNED NOT NULL,
    `seller_id` INT UNSIGNED NOT NULL,
    `comment` VARCHAR(4000),
    `moderation_reason_id` INT UNSIGNED,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_ssp_link_context_rtb__seller_id_site_id` (`seller_id`, `site_id`),
    UNIQUE INDEX `uniq_ssp_link_context_rtb__context_rtb_id` (`context_rtb_id`),
    FOREIGN KEY `fk_ssp_link_context_rtb__seller_id___ssp_seller__id` (`seller_id`)
        REFERENCES `ssp_seller` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_context_rtb__site_id___ssp_site__id` (`site_id`)
        REFERENCES `ssp_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_context_rtb__context_rtb_id___ssp_context_on_site_c` (`context_rtb_id`)
        REFERENCES `ssp_context_on_site_campaign` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'