CREATE TABLE IF NOT EXISTS `ssp_link_mobile_app` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `application_id` BIGINT UNSIGNED NOT NULL,
    `mobile_app_id` INT UNSIGNED DEFAULT NULL,
    `tokens` VARCHAR(10000) COLLATE 'utf8_bin' NOT NULL,
    `weight` BIGINT UNSIGNED NOT NULL,
    `seller_id` INT UNSIGNED NOT NULL,
    `comment` VARCHAR(4000),
    `moderation_reason_id` INT UNSIGNED,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_ssp_link_mobile_app__seller_id_application_id` (`seller_id`, `application_id`),
    INDEX `ssp_link_mobile_app__application_id` (`application_id`),
    INDEX `ssp_link_mobile_app__mobile_app_id` (`mobile_app_id`),
    INDEX `ssp_link_mobile_app__tokens` (`tokens`),
    FOREIGN KEY `fk_ssp_link_mobile_app__application_id___ssp_application__id` (`application_id`)
        REFERENCES `ssp_application` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_mobile_app__mobile_app_id___ssp_mobile_app_settings` (`mobile_app_id`)
        REFERENCES `ssp_mobile_app_settings` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_mobile_app__seller_id___ssp_seller__id` (`seller_id`)
        REFERENCES `ssp_seller` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'