CREATE TABLE IF NOT EXISTS `ssp_video_an_site` (
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `page_id` BIGINT UNSIGNED,
    `comment` TEXT,
    `owner_id` INT UNSIGNED NOT NULL,
    `source_id` BIGINT UNSIGNED NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `block_title` VARCHAR(255) DEFAULT '',
    `view_images` BOOLEAN NOT NULL DEFAULT '1',
    `behavioral_targeting` BOOLEAN NOT NULL DEFAULT '1',
    `banner_langs` VARCHAR(255) NOT NULL DEFAULT '[\"by\",\"en\",\"kz\",\"ru\",\"uk\"]',
    `cpa` INT UNSIGNED NOT NULL,
    `mobile_app_mode` TINYINT NOT NULL DEFAULT '0',
    `fast_context` BOOLEAN NOT NULL DEFAULT '0',
    `only_picture` BOOLEAN NOT NULL DEFAULT '0',
    `family_filter` BOOLEAN NOT NULL DEFAULT '1',
    `seller_id` INT UNSIGNED NOT NULL,
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_ssp_video_an_site__page_id` (`page_id`),
    FOREIGN KEY `fk_ssp_video_an_site__owner_id_seller_id___ssp_seller__user_id_` (`owner_id`, `seller_id`)
        REFERENCES `ssp_seller` (`user_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_video_an_site__source_id___ssp_application__id` (`source_id`)
        REFERENCES `ssp_application` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_video_an_site__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'