CREATE TABLE IF NOT EXISTS `ssp_video_an_site_rtb` (
    `campaign_id` BIGINT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME DEFAULT '1970-01-01 03:00:00',
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `direct_block` VARCHAR(32) NOT NULL,
    `media_block` VARCHAR(12) NOT NULL,
    `limit` INT UNSIGNED,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `geo` MEDIUMTEXT,
    `blind` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '1',
    `mincpm` VARCHAR(16) NOT NULL DEFAULT '0',
    `alternative_code` TEXT NOT NULL,
    `border_radius` BOOLEAN,
    `border_type` VARCHAR(8),
    `favicon` BOOLEAN DEFAULT '0',
    `no_sitelinks` BOOLEAN DEFAULT '0',
    `links_underline` BOOLEAN DEFAULT '1',
    `site_bg_color` VARCHAR(6),
    `bg_color` VARCHAR(6),
    `border_color` VARCHAR(6),
    `header_bg_color` VARCHAR(6),
    `sitelinks_color` VARCHAR(6),
    `title_color` VARCHAR(6),
    `text_color` VARCHAR(6),
    `url_color` VARCHAR(6),
    `url_background_color` VARCHAR(6),
    `hover_color` VARCHAR(6),
    `font_family` VARCHAR(15),
    `font_size` VARCHAR(3),
    `title_font_size` TINYINT UNSIGNED,
    `adaptive_width` VARCHAR(4) NOT NULL DEFAULT '',
    `adaptive_height` VARCHAR(4) NOT NULL DEFAULT '',
    `comment` TEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `adfox_block` BOOLEAN NOT NULL DEFAULT '0',
    `show_video` BOOLEAN NOT NULL DEFAULT '0',
    `media_active` BOOLEAN,
    `media_blocked` BOOLEAN,
    `media_cpm` SMALLINT UNSIGNED,
    `text_active` BOOLEAN,
    `text_blocked` BOOLEAN,
    `text_cpm` SMALLINT UNSIGNED,
    `video_active` BOOLEAN,
    `video_blocked` BOOLEAN,
    `video_cpm` SMALLINT UNSIGNED,
    `is_custom_format_direct` BOOLEAN NOT NULL DEFAULT '0',
    `horizontal_align` BOOLEAN DEFAULT '1',
    `block_type` VARCHAR(18),
    `callouts` BOOLEAN,
    `opts` JSON NOT NULL,
    PRIMARY KEY (`campaign_id`, `id`),
    FOREIGN KEY `fk_ssp_video_an_site_rtb__campaign_id___ssp_video_an_site__page` (`campaign_id`)
        REFERENCES `ssp_video_an_site` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'