CREATE TABLE IF NOT EXISTS `statistics_context_on_site_market` (
    `dt` DATE NOT NULL,
    `campaign_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `tag_id` BIGINT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `market_context_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `market_context_clicks` INT UNSIGNED NOT NULL DEFAULT '0',
    `market_context_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `market_context_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `market_context_partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `market_context_partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `campaign_id`, `block_id`, `currency_id`, `tag_id`),
    INDEX `statistics_context_on_site_market__campaign_id_block_id_dt` (`campaign_id`, `block_id`, `dt`),
    FOREIGN KEY `fk_statistics_context_on_site_market__currency_id___currencies_` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_context_on_site_market__campaign_id_block_id___co` (`campaign_id`, `block_id`)
        REFERENCES `context_on_site_market` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'