CREATE TABLE IF NOT EXISTS `statistics_context_on_site_market_api` (
    `dt` DATE NOT NULL,
    `campaign_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `market_api_context_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `market_api_context_clicks` INT UNSIGNED NOT NULL DEFAULT '0',
    `market_api_context_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `market_api_context_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `market_api_context_partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `market_api_context_partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `campaign_id`, `block_id`, `currency_id`),
    INDEX `statistics_context_on_site_market_api__campaign_id_block_id_dt` (`campaign_id`, `block_id`, `dt`),
    FOREIGN KEY `fk_statistics_context_on_site_market_api__currency_id___currenc` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_context_on_site_market_api__campaign_id_block_id_` (`campaign_id`, `block_id`)
        REFERENCES `context_on_site_market_api` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'