CREATE TABLE IF NOT EXISTS `statistics_dsp` (
    `dt` DATE NOT NULL,
    `dsp_id` BIGINT UNSIGNED NOT NULL,
    `campaign_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `dsp_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `dsp_bids` INT UNSIGNED NOT NULL DEFAULT '0',
    `all_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `dsp_charging_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `dsp_charging_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `charging_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `charging_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_real_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_real_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `dsp_id`, `currency_id`, `campaign_id`),
    FOREIGN KEY `fk_statistics_dsp__dsp_id___dsp__id` (`dsp_id`)
        REFERENCES `dsp` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_dsp__currency_id___currencies__id` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'