CREATE TABLE IF NOT EXISTS `statistics_internal_context_on_site_natural` (
    `dt` DATE NOT NULL,
    `campaign_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `tag_id` BIGINT UNSIGNED NOT NULL,
    `natural_block_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `natural_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_bad_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_bad_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_bad_win_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_bad_win_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_bad_win_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `natural_bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_direct_clicks` INT UNSIGNED NOT NULL DEFAULT '0',
    `natural_block_direct_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `campaign_id`, `block_id`, `dsp_id`, `currency_id`, `tag_id`),
    INDEX `statistics_internal_context_on_site_natural__campaign_id_block_i` (`campaign_id`, `block_id`, `dt`),
    INDEX `statistics_internal_context_on_site_natural__dsp_id_dt` (`dsp_id`, `dt`),
    FOREIGN KEY `fk_statistics_internal_context_on_site_natural__currency_id___c` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_internal_context_on_site_natural__campaign_id_blo` (`campaign_id`, `block_id`)
        REFERENCES `internal_context_on_site_natural` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'