CREATE TABLE IF NOT EXISTS `statistics_internal_context_on_site_stripe` (
    `dt` DATE NOT NULL,
    `campaign_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL,
    `stripe_shows` INT UNSIGNED NOT NULL,
    `stripe_clicks` INT UNSIGNED NOT NULL,
    `stripe_hits` INT UNSIGNED NOT NULL,
    `stripe_all_w_nds` BIGINT UNSIGNED NOT NULL,
    `stripe_all_wo_nds` BIGINT UNSIGNED NOT NULL,
    `all_w_nds` BIGINT UNSIGNED NOT NULL,
    `all_wo_nds` BIGINT UNSIGNED NOT NULL,
    PRIMARY KEY (`dt`, `campaign_id`, `block_id`, `currency_id`),
    INDEX `statistics_internal_context_on_site_stripe__campaign_id_block_id` (`campaign_id`, `block_id`, `dt`, `currency_id`),
    FOREIGN KEY `fk_statistics_internal_context_on_site_stripe__currency_id___cu` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'