CREATE TABLE IF NOT EXISTS `statistics_internal_search_on_site_direct` (
    `dt` DATE NOT NULL,
    `campaign_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `tag_id` BIGINT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `direct_search_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `direct_search_clicks` INT UNSIGNED NOT NULL DEFAULT '0',
    `direct_search_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `direct_search_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `campaign_id`, `block_id`, `currency_id`, `tag_id`),
    INDEX `statistics_internal_search_on_site_direct__campaign_id_block_id_` (`campaign_id`, `block_id`, `dt`),
    FOREIGN KEY `fk_statistics_internal_search_on_site_direct__currency_id___cur` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_internal_search_on_site_direct__campaign_id_block` (`campaign_id`, `block_id`)
        REFERENCES `internal_search_on_site_direct` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'