CREATE TABLE IF NOT EXISTS `statistics_reports` (
    `id` VARCHAR(64) NOT NULL,
    `report_id` VARCHAR(64),
    `caption_en` VARCHAR(255) NOT NULL, `caption_ru` VARCHAR(255) NOT NULL,
    `description` VARCHAR(255),
    `level` VARCHAR(64) NOT NULL,
    `query` TEXT NOT NULL,
    `owner_id` BIGINT UNSIGNED,
    `not_show` BOOLEAN NOT NULL DEFAULT '0',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `report_type` ENUM('pi', 'mol') NOT NULL DEFAULT 'pi',
    `category_bits` INT UNSIGNED NOT NULL DEFAULT '0',
    `report_order` INT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    FOREIGN KEY `fk_statistics_reports__level___statistics_reports_level_order__` (`level`)
        REFERENCES `statistics_reports_level_order` (`level_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'