CREATE TABLE IF NOT EXISTS `statistics_ssp_mobile_app_rtb` (
    `dt` DATE NOT NULL,
    `page_id` BIGINT UNSIGNED,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL,
    `ssp_mobile_rtb_block_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_block_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_block_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_block_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_block_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `ssp_mobile_rtb_partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `page_id`, `block_id`, `dsp_id`, `currency_id`),
    INDEX `statistics_ssp_mobile_app_rtb__page_id_block_id_dt` (`page_id`, `block_id`, `dt`),
    INDEX `statistics_ssp_mobile_app_rtb__dsp_id_dt` (`dsp_id`, `dt`),
    FOREIGN KEY `fk_statistics_ssp_mobile_app_rtb__currency_id___currencies__id` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_ssp_mobile_app_rtb__page_id_block_id___ssp_mobile` (`page_id`, `block_id`)
        REFERENCES `ssp_mobile_app_rtb` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'