CREATE TABLE IF NOT EXISTS `statistics_video_an_site_inpage` (
    `dt` DATE NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `tag_id` BIGINT UNSIGNED NOT NULL,
    `inpage_block_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_direct_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_direct_clicks` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_bad_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_bad_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_bad_win_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_bad_win_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_bad_win_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_bad_win_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_bad_win_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_win_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_win_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `inpage_block_win_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `page_id`, `block_id`, `dsp_id`, `currency_id`, `tag_id`),
    INDEX `statistics_video_an_site_inpage__page_id_block_id_dt` (`page_id`, `block_id`, `dt`),
    INDEX `statistics_video_an_site_inpage__dsp_id_dt` (`dsp_id`, `dt`),
    FOREIGN KEY `fk_statistics_video_an_site_inpage__currency_id___currencies__i` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_video_an_site_inpage__page_id_block_id___video_an` (`page_id`, `block_id`)
        REFERENCES `video_an_site_inpage` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'