CREATE TABLE IF NOT EXISTS `statistics_video_an_site_instream_publisher` (
    `dt` DATE NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `publisher_id` VARCHAR(255) NOT NULL DEFAULT '',
    `content_id` VARCHAR(255) NOT NULL DEFAULT '',
    `publisher_name` VARCHAR(255) NOT NULL DEFAULT '',
    `content_name` VARCHAR(255) NOT NULL DEFAULT '',
    `clid` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_all_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `bk_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bk_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bk_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bk_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `page_id`, `block_id`, `dsp_id`, `currency_id`, `publisher_id`, `content_id`, `clid`),
    INDEX `statistics_video_an_site_instream_publisher__page_id_block_id_dt` (`page_id`, `block_id`, `dt`),
    INDEX `statistics_video_an_site_instream_publisher__dsp_id_dt` (`dsp_id`, `dt`),
    INDEX `statistics_video_an_site_instream_publisher__clid_content_id_con` (`clid`, `content_id`, `content_name`, `currency_id`, `page_id`, `publisher_id`, `publisher_name`),
    FOREIGN KEY `fk_statistics_video_an_site_instream_publisher__page_id_block_i` (`page_id`, `block_id`)
        REFERENCES `video_an_site_instream` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'