CREATE TABLE IF NOT EXISTS `user_notifications` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `notification_id` BIGINT UNSIGNED NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `accessor` VARCHAR(255),
    `opts` JSON NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `user_notifications__user_id` (`user_id`),
    INDEX `user_notifications__notification_id_user_id` (`notification_id`, `user_id`),
    FOREIGN KEY `fk_user_notifications__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_user_notifications__notification_id___notification__id` (`notification_id`)
        REFERENCES `notification` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'