CREATE TABLE IF NOT EXISTS `users` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `uid` BIGINT UNSIGNED NOT NULL,
    `login` VARCHAR(40) NOT NULL,
    `client_id` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `name` VARCHAR(255) NOT NULL DEFAULT '',
    `lastname` VARCHAR(255) NOT NULL DEFAULT '',
    `midname` VARCHAR(255) NOT NULL DEFAULT '',
    `email` VARCHAR(255) NOT NULL,
    `phone` VARCHAR(255) NOT NULL DEFAULT '',
    `accountant_email` VARCHAR(255),
    `newsletter` BOOLEAN NOT NULL DEFAULT '1',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `country_id` INT UNSIGNED,
    `business_unit` BOOLEAN NOT NULL DEFAULT '0',
    `no_stat_monitoring_emails` BOOLEAN NOT NULL DEFAULT '1',
    `is_tutby` BOOLEAN NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `block_light_form_enabled` BOOLEAN NOT NULL DEFAULT '0',
    `opts` JSON NOT NULL,
    `has_tutby_agreement` BOOLEAN GENERATED ALWAYS AS (opts->"$.has_tutby_agreement") VIRTUAL,
    `has_common_offer` BOOLEAN GENERATED ALWAYS AS (opts->"$.has_common_offer") VIRTUAL,
    `has_approved` BOOLEAN GENERATED ALWAYS AS (opts->"$.has_approved") VIRTUAL,
    `has_rsya` BOOLEAN GENERATED ALWAYS AS (opts->"$.has_rsya") VIRTUAL,
    `has_mobile_mediation` BOOLEAN GENERATED ALWAYS AS (opts->"$.has_mobile_mediation") VIRTUAL,
    `last_payout` DATETIME,
    `need_to_email_processing` BOOLEAN NOT NULL DEFAULT '0',
    `is_mobile_mediation` BOOLEAN NOT NULL DEFAULT '0',
    `is_video_blogger` BOOLEAN NOT NULL DEFAULT '0',
    `domain_login` VARCHAR(255),
    `is_adfox_partner` BOOLEAN NOT NULL DEFAULT '0',
    `is_games` BOOLEAN NOT NULL DEFAULT '0',
    `is_dm_lite` BOOLEAN NOT NULL DEFAULT '0',
    `is_efir_blogger` BOOLEAN NOT NULL DEFAULT '0',
    `is_deleted` BOOLEAN NOT NULL DEFAULT '0',
    `deletion_date` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_users__login` (`login`),
    INDEX `users__client_id` (`client_id`),
    INDEX `users__uid` (`uid`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'