CREATE TABLE IF NOT EXISTS `video_an_site` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `caption` VARCHAR(255) NOT NULL,
    `domain` VARCHAR(255) NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `platform` TINYINT UNSIGNED NOT NULL,
    `comment` VARCHAR(255),
    `skin` VARCHAR(255) NOT NULL DEFAULT '',
    `title` VARCHAR(255) NOT NULL DEFAULT '',
    `skip_delay` TINYINT UNSIGNED NOT NULL DEFAULT '5',
    `skip_time_left_show` BOOLEAN NOT NULL,
    `time_left_show` BOOLEAN NOT NULL DEFAULT '1',
    `skin_timeout` SMALLINT UNSIGNED NOT NULL DEFAULT '5000',
    `vast_version` TINYINT(1) UNSIGNED NOT NULL DEFAULT '3',
    `vast_timeout` SMALLINT UNSIGNED NOT NULL DEFAULT '5000',
    `video_timeout` SMALLINT UNSIGNED NOT NULL DEFAULT '5000',
    `buffer_full_timeout` SMALLINT UNSIGNED NOT NULL DEFAULT '5000',
    `buffer_empty_limit` TINYINT UNSIGNED NOT NULL DEFAULT '5',
    `vpaid_enabled` BOOLEAN NOT NULL DEFAULT '1',
    `vpaid_timeout` SMALLINT UNSIGNED NOT NULL DEFAULT '5000',
    `wrapper_timeout` SMALLINT UNSIGNED NOT NULL DEFAULT '5000',
    `wrapper_max_count` TINYINT UNSIGNED NOT NULL DEFAULT '3',
    `blocks_limit` BIGINT NOT NULL DEFAULT '200',
    `blocks_count` BIGINT NOT NULL DEFAULT '0',
    `partner_type` VARCHAR(10),
    `pixels` MEDIUMTEXT,
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `user_synchronization` BOOLEAN NOT NULL DEFAULT '0',
    `tag_id` INT UNSIGNED,
    `unmoderated_rtb_auction` BOOLEAN NOT NULL DEFAULT '0',
    `tier` TINYINT DEFAULT '3',
    `metrica_counters` VARCHAR(1024) NOT NULL DEFAULT '',
    `opts` JSON NOT NULL,
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    PRIMARY KEY (`id`),
    INDEX `video_an_site__multistate` (`multistate`),
    INDEX `video_an_site__domain` (`domain`),
    FOREIGN KEY `fk_video_an_site__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_video_an_site__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'