CREATE TABLE IF NOT EXISTS `video_an_site_fullscreen` (
    `page_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `mincpm` SMALLINT UNSIGNED,
    `geo` MEDIUMTEXT,
    `blind` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `category_id` BIGINT UNSIGNED NOT NULL,
    `category_path` VARCHAR(255) NOT NULL DEFAULT '',
    `type` TINYINT UNSIGNED NOT NULL,
    `comment` VARCHAR(255) NOT NULL DEFAULT '',
    `max_duration` TINYINT UNSIGNED NOT NULL DEFAULT '180',
    `alternative_code` MEDIUMTEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `adfox_block` BOOLEAN NOT NULL DEFAULT '0',
    `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    `video_active` BOOLEAN,
    `video_blocked` BOOLEAN,
    `video_cpm` SMALLINT UNSIGNED,
    `video_performance_active` BOOLEAN,
    `video_performance_blocked` BOOLEAN,
    `video_performance_cpm` SMALLINT UNSIGNED,
    `video_motion` BOOLEAN NOT NULL DEFAULT '1',
    `opts` JSON NOT NULL,
    PRIMARY KEY (`page_id`, `id`),
    INDEX `video_an_site_fullscreen__multistate` (`multistate`),
    INDEX `video_an_site_fullscreen__id` (`id`),
    FOREIGN KEY `fk_video_an_site_fullscreen__page_id___video_an_site__id` (`page_id`)
        REFERENCES `video_an_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'