CREATE TABLE IF NOT EXISTS `video_an_site_instream` (
    `page_id` INT UNSIGNED NOT NULL,
    `vmap_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `mincpm` SMALLINT UNSIGNED,
    `geo` MEDIUMTEXT,
    `blind` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `category_id` BIGINT UNSIGNED NOT NULL,
    `category_path` VARCHAR(255) NOT NULL DEFAULT '',
    `type` TINYINT UNSIGNED NOT NULL,
    `comment` VARCHAR(255) NOT NULL DEFAULT '',
    `start_time` SMALLINT UNSIGNED,
    `allow_multiple_dsp_ads` BOOLEAN NOT NULL DEFAULT '1',
    `max_duration` SMALLINT UNSIGNED NOT NULL DEFAULT '180',
    `count_positions` TINYINT UNSIGNED NOT NULL DEFAULT '6',
    `alternative_code` MEDIUMTEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `adfox_block` BOOLEAN NOT NULL DEFAULT '0',
    `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    `video_active` BOOLEAN,
    `video_blocked` BOOLEAN,
    `video_cpm` SMALLINT UNSIGNED,
    `video_performance_active` BOOLEAN,
    `video_performance_blocked` BOOLEAN,
    `video_performance_cpm` SMALLINT UNSIGNED,
    `video_motion` BOOLEAN NOT NULL DEFAULT '1',
    `repeat` TINYINT UNSIGNED,
    `broadcast_replace` TINYINT UNSIGNED,
    `pip` TINYINT UNSIGNED,
    `repeat_after` SMALLINT UNSIGNED,
    `max_repeat_count` SMALLINT UNSIGNED,
    `server_side` TINYINT UNSIGNED,
    `try_client` TINYINT UNSIGNED,
    `opts` JSON NOT NULL,
    PRIMARY KEY (`page_id`, `id`),
    INDEX `video_an_site_instream__multistate` (`multistate`),
    INDEX `video_an_site_instream__id` (`id`),
    FOREIGN KEY `fk_video_an_site_instream__page_id___video_an_site__id` (`page_id`)
        REFERENCES `video_an_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_video_an_site_instream__page_id_vmap_id___video_scenaries__p` (`page_id`, `vmap_id`)
        REFERENCES `video_scenaries` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'