CREATE TABLE IF NOT EXISTS `widgets_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_user_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `widgets_action_log__dt_elem_user_id_action` (`dt`, `elem_user_id`, `action`),
    INDEX `widgets_action_log__elem_user_id_action` (`elem_user_id`, `action`),
    FOREIGN KEY `fk_widgets_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_widgets_action_log__elem_user_id___widgets__user_id` (`elem_user_id`)
        REFERENCES `widgets` (`user_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'