package ru.yandex.partner.libs.exceptions;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.http.HttpStatus;

public enum HttpErrorStatusEnum {
    ERROR__NEED_AUTH(0, HttpStatus.UNAUTHORIZED),
    ERROR__PARAMS(1, HttpStatus.BAD_REQUEST),
    ERROR__CONFLICT(2, HttpStatus.CONFLICT),
    ERROR__FORBIDDEN(3, HttpStatus.FORBIDDEN),
    ERROR__VALIDATION(4, HttpStatus.BAD_REQUEST),
    ERROR__INTERNAL(5, HttpStatus.INTERNAL_SERVER_ERROR),
    ERROR__NOT_FOUND(6, HttpStatus.NOT_FOUND),
    ERROR__MANY_REQ(7, HttpStatus.TOO_MANY_REQUESTS),
    ERROR__NOT_ACCEPTABLE(8, HttpStatus.NOT_ACCEPTABLE),
    ERROR__MEDIA_TYPE(9, HttpStatus.UNSUPPORTED_MEDIA_TYPE),
    ERROR__NOT_IMPLEMENTED(10, HttpStatus.NOT_IMPLEMENTED);

    private static final Map<HttpStatus, Integer> STATUS_ID_MAP = createMapStatusToId();
    private final HttpErrorStatus httpErrorStatus;

    HttpErrorStatusEnum(int id, HttpStatus httpStatus) {
        this.httpErrorStatus = new HttpErrorStatus(id, httpStatus);
    }

    public HttpErrorStatus getHttpErrorStatus() {
        return httpErrorStatus;
    }

    public static Integer getIdByHttpStatus(HttpStatus httpStatus) {
        return STATUS_ID_MAP.getOrDefault(httpStatus, ERROR__INTERNAL.httpErrorStatus.getId());
    }

    public HttpStatus getHttpStatus() {
        return httpErrorStatus.getHttpStatus();
    }

    public int getId() {
        return httpErrorStatus.getId();
    }

    private static Map<HttpStatus, Integer> createMapStatusToId() {
        return Stream.of(values())
                // отфильтровываем так как это ошибка валидации такие ошибки должны идти через
                // I18nResponseStatusException
                .filter(status -> status != ERROR__VALIDATION)
                .collect(Collectors.toMap(
                        httpErrorStatusEnum -> httpErrorStatusEnum.httpErrorStatus.getHttpStatus(),
                        httpErrorStatusEnum -> httpErrorStatusEnum.httpErrorStatus.getId()
                ));
    }
}
