package ru.yandex.partner.libs.exceptions;

import org.springframework.web.server.ResponseStatusException;

import ru.yandex.partner.libs.i18n.GettextMsg;

public class I18nResponseStatusException extends ResponseStatusException implements Translatable {
    private final HttpErrorStatus httpErrorStatus;
    private final GettextMsg i18nMessage;

    public I18nResponseStatusException(HttpErrorStatusEnum status) {
        super(status.getHttpStatus());
        this.httpErrorStatus = status.getHttpErrorStatus();
        this.i18nMessage = null;
    }

    public I18nResponseStatusException(HttpErrorStatusEnum status, GettextMsg i18nMessage) {
        super(status.getHttpStatus());
        this.httpErrorStatus = status.getHttpErrorStatus();
        this.i18nMessage = i18nMessage;
    }

    public I18nResponseStatusException(HttpErrorStatusEnum status, Throwable cause) {
        super(status.getHttpStatus(), null, cause);
        this.httpErrorStatus = status.getHttpErrorStatus();
        this.i18nMessage = null;
    }

    public I18nResponseStatusException(HttpErrorStatusEnum status, GettextMsg i18nMessage, Throwable cause) {
        super(status.getHttpStatus(), null, cause);
        this.httpErrorStatus = status.getHttpErrorStatus();
        this.i18nMessage = i18nMessage;
    }

    public I18nResponseStatusException(HttpErrorStatus httpErrorStatus, GettextMsg i18nMessage) {
        super(httpErrorStatus.getHttpStatus());
        this.httpErrorStatus = httpErrorStatus;
        this.i18nMessage = i18nMessage;
    }

    @Override
    public GettextMsg getI18nMessage() {
        return i18nMessage;
    }

    public HttpErrorStatus getHttpErrorStatus() {
        return httpErrorStatus;
    }
}
