package ru.yandex.partner.libs.exceptions;

import ru.yandex.partner.libs.i18n.GettextMsg;

public class PartnerI18nRuntimeException extends PartnerRuntimeException implements Translatable {
    private final GettextMsg i18nMessage;

    public PartnerI18nRuntimeException(GettextMsg i18nMessage) {
        this.i18nMessage = i18nMessage;
    }

    public PartnerI18nRuntimeException(String message, GettextMsg i18nMessage) {
        super(message);
        this.i18nMessage = i18nMessage;
    }

    public PartnerI18nRuntimeException(String message, Throwable cause, GettextMsg i18nMessage) {
        super(message, cause);
        this.i18nMessage = i18nMessage;
    }

    public PartnerI18nRuntimeException(Throwable cause, GettextMsg i18nMessage) {
        super(cause);
        this.i18nMessage = i18nMessage;
    }

    public PartnerI18nRuntimeException(String fingerPrint, String message, GettextMsg i18nMessage) {
        super(fingerPrint, message);
        this.i18nMessage = i18nMessage;
    }

    public PartnerI18nRuntimeException(String fingerPrint, String message, Throwable cause, GettextMsg i18nMessage) {
        super(fingerPrint, message, cause);
        this.i18nMessage = i18nMessage;
    }

    @Override
    public GettextMsg getI18nMessage() {
        return i18nMessage;
    }
}
