package ru.yandex.partner.libs.exceptions;

public class PartnerRuntimeException extends RuntimeException implements FingerPrintable {
    private String fingerPrint;

    public PartnerRuntimeException() {
    }

    public PartnerRuntimeException(String message) {
        super(message);
    }

    public PartnerRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public PartnerRuntimeException(Throwable cause) {
        super(cause);
    }

    public PartnerRuntimeException(String fingerPrint, String message) {
        super(message);
        this.fingerPrint = fingerPrint;
    }

    public PartnerRuntimeException(String fingerPrint, String message, Throwable cause) {
        super(message, cause);
        this.fingerPrint = fingerPrint;
    }

    @Override
    public String getFingerPrint() {
        return Utils.getFingerPrint(fingerPrint, getStackTrace());
    }
}
