package ru.yandex.partner.libs.extservice;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ThirdPartyServiceMsg implements GettextMsg {
    STATUS_CODE_NOT_OK(msg("Got not 200 status code: %s")),
    RESPONSE_IS_NOT_VALID_JSON(msg("Response is not a valid json."));

    private static final String KEYSET_NAME = "lib__Application__Model__API__Yandex__HTTPMOL.pm";
    private final GettextMsgPayload payload;


    ThirdPartyServiceMsg(GettextMsgPayload.Builder builder) {
        payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
