package ru.yandex.partner.libs.extservice.balance;

import java.time.LocalDate;
import java.util.Objects;

import ru.yandex.partner.core.CoreConstants;

public class BalanceContractUtils {
    private BalanceContractUtils() {
    }

    public static boolean isLiveContract(LocalDate date, ContractLiveData contractLiveData) {
        return !date.isBefore(contractLiveData.getDt())
                && (contractLiveData.getContractEndDt() == null || !date.isAfter(contractLiveData.getContractEndDt()))
                && (contractLiveData.getIsCanceled() == null || date.isBefore(contractLiveData.getIsCanceled()))
                && (contractLiveData.getIsSigned() != null
                || contractLiveData.getIsFaxed() != null
                || isOferta2TestMode(contractLiveData.getContractType(), contractLiveData.getTestMode()));
    }

    public static boolean isOferta2TestMode(Integer contractType, Integer testMode) {
        return Objects.equals(contractType, CoreConstants.BalanceContractType.OFFER) && isTestMode(testMode);
    }

    public static boolean isTestMode(Integer testMode) {
        return testMode != null && testMode == 1;
    }

}
